"use strict"; // prevent lazy programming in JavaScript :)

// URL for dataFile
var URL = "./AntenniPooraja/Script/Rotator_2.json"


// every time if the DOM refresh
$(document).ready(function() {
	
	S7Framework.initAuto("#loading_div", $.init);
	
} );

$.init = function(){
	// read Values first time
	S7Framework.readData(URL, "init read data", deployValues);
	//EVENTHANDLING 
	var data; //common variable for sending different data to the s7 framework
	var ant;
		// Kaivita Button - Start moving to the new azimuth
	$("#Kaivita_Button").click(function(){
	data = '"Web2Plc".Start_moving_AZ_web=1';
	S7Framework.writeData(URL, data, "KAIVITA");		
	})
		//Stop Button - Stop moving azimuth rotator (emergency stop)
	$("#Stop_Button" ).click(function(){
	data = '"Web2Plc".Stop_Button_web=1';
	S7Framework.writeData(URL, data, "STOP");	
	})	
		// Vaheta Button - change antenna polarity - start moving polarity rotator
	$("#Ch_POL_Button").click(function(){
	data = '"Web2Plc".Change_POL_web=1';
	S7Framework.writeData(URL, data, "VAHETA_POL");		
	})
		//Stop Button_2 - Stop moving polarity rotator (emergency stop)
	$("#Stop_Button_2" ).click(function(){
	data = '"Web2Plc".Stop_Button_web=1';
	S7Framework.writeData(URL, data, "STOP");	
	})
		//Antennid kinni-lahti - connect / disconnect antennas
	$("#Antennid_kinni_lahti" ).click(function(){
	ant = document.getElementById('Antennid_kinni_lahti').checked;
	if(ant){
		//alert('Checked');
		data = '"Web2Plc".Add_Relay_1_web=1';
		S7Framework.writeData(URL, data, "ANTENNID");
		}
	else{
		//alert('Unchecked');	
		data = '"Web2Plc".Add_Relay_1_web=0';
		S7Framework.writeData(URL, data, "ANTENNID");		
		}	
	})
	
	//Reset Button - this button resets PC, not necessary for common platform 
	$("#Reset_Button").click(function(){
	data = '"Web2Plc".Add_Relay_2_web=1';
	S7Framework.writeData(URL, data, "Reset");		
	})
}


// function to deploy values into Webpage
function deployValues(values)
{
	//this is for svg compass indicator (azimuth),
		//not necessary for the common platform
		var cXY = 150; 
		var attr2 = 0;
		var asimuut; //azimuth value degrees
	// getting data from json string - bit 0
	// status feedback from controller
	// true - motors are moving, false - motors are not moving
	if (values[0] == false)
	{
		$('#AZ_Motors_moving').html("---OK---");
		$('#AZ_Motors_moving').attr('style', 'color:green');
		$('#Blinker').html("");
		$('#Stop_Button').attr('style', 'opacity: 0.5');
		$('#Kaivita_Button').attr('style', 'opacity: 1.0');
	}
	else
	{
		$('#AZ_Motors_moving').html("Liigutan");//Toimetan
		$('#AZ_Motors_moving').attr('style', 'color:red');
		$('#Stop_Button').attr('style', 'opacity: 1.0');		
		$('#Blinker').html("!!!");
		$('#Kaivita_Button').attr('style', 'opacity: 0.5');		
	}
//POLARITY Status HOR indicator bit 1, 2 and 3
	if ((values[2] == false) && (values[3] == false) )
	{
		$('#Curr_Pol_Status').html("");
	}
	else if ((values[2] == true) && (values[3] == false))
	{
		$('#Curr_Pol_Status').html("HOR");
	}
//POLARITY Status VER indicator
	else
	{
		$('#Curr_Pol_Status').html("VER");
	}
//POLARITY Motors are Moving or not - bit 1, status feedback from controller
	// true - motors are moving, false - motors are not moving
	if (values[1] == false)
	{
		$('#POL_Motors_moving').html("---OK---");
		$('#POL_Motors_moving').attr('style', 'color:green');
		$('#Blinker_2').html("");
		$('#Stop_Button_2').attr('style', 'opacity: 0.5');
		$('#Ch_POL_Button').attr('style', 'opacity: 1.0');
	}
	else
	{
		$('#POL_Motors_moving').html("Liigutan");//Toimetan
		$('#POL_Motors_moving').attr('style', 'color:red');
		$('#Blinker_2').html("!!!");
		$('#Stop_Button_2').attr('style', 'opacity: 1.0');	
		$('#Ch_POL_Button').attr('style', 'opacity: 0.5');
	}	
// bit 4
// Antennas connected or disconnected, status feedback from controller
	if (values[4] == false)
	{
		document.getElementById("Antennid_kinni_lahti").checked = false;
	}
	else
	{
		document.getElementById("Antennid_kinni_lahti").checked = true;
	}
// PC power status feedback from controller bit 5 ()
// Not necessary for common platform
	if (values[5] == false)
	{
		$('#Restarting_PC').html("PC toide peal");
		$('#Restarting_PC').attr('style', 'color:green');
		$('#Blinker_3').html("");
		$('#Reset_Button').attr('style', 'opacity: 0.8');
	}
	else
	{
		$('#Restarting_PC').html("PC toide maas");//Toimetan
		$('#Restarting_PC').attr('style', 'color:red');
		$('#Blinker_3').html("!!!");
		$('#Reset_Button').attr('style', 'opacity: 0.5');	
	}

// index 6 - (word) current azimuth feedback from controller
	$('#Curr_Deg_AZ').html( values[6] );
// This is for the azimuth compass indicator. Not necessary for common platform
	asimuut = JSON.parse(values[6]);
	attr2 = "rotate(" + asimuut + "," + cXY + "," + cXY + ")";
	document.getElementById("transformed2").setAttribute("transform", attr2);
// index 8 - (word) new entered azimuth feedback from controller id = "rotate"
// Sending new entered value to the controller - see function redisplay()
	$('#rotate').attr('value', values[8]);
	var attr = "rotate(" + values[8] + "," + cXY + "," + cXY + ")";
	document.getElementById("transformed").setAttribute("transform",attr);
	//Index 7 (word)
	//POLARITY feedback from controller, numeric degrees
	$('#Curr_Deg_Pol').html( values[7] );	

	setTimeout(S7Framework.readData(URL, "init read data", deployValues), 1000);
}
function redisplay()
{
	var cXY = 150;

	var rotate = document.getElementById("rotate").value;

	if ( (rotate >= 0 && rotate <= 450 ) == false)
	{
		alert("Value must be between 0 and 450!");
		return;
	}
	else{
		//Set new asimuut in controller
		var data1 = '"Web2Plc".Entered_AZ_web=' + rotate;
		S7Framework.writeData(URL, data1, "ROTATE");

	}
}
		
